/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.server;

import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.sonarlint.eclipse.core.internal.server.IServerListener;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarsource.sonarlint.core.client.api.common.RuleDetails;
import org.sonarsource.sonarlint.core.client.api.common.analysis.AnalysisResults;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.RemoteModule;
import org.sonarsource.sonarlint.core.client.api.util.TextSearchIndex;

public interface IServer {
    public String getId();

    public String getHost();

    @CheckForNull
    public String getOrganization();

    public boolean hasAuth();

    public void delete();

    public String getUpdateDate();

    public String getServerVersion();

    public String getSonarLintEngineState();

    public void updateStorage(IProgressMonitor var1);

    public void addServerListener(IServerListener var1);

    public void removeServerListener(IServerListener var1);

    public TextSearchIndex<RemoteModule> getModuleIndex();

    public Map<String, RemoteModule> getRemoteModules();

    public AnalysisResults runAnalysis(ConnectedAnalysisConfiguration var1, IssueListener var2, IProgressMonitor var3);

    public RuleDetails getRuleDescription(String var1);

    public void updateProjectStorage(String var1, IProgressMonitor var2);

    public boolean isStorageUpdated();

    public List<ISonarLintProject> getBoundProjects();

    public void notifyAllListeners();

    public boolean isUpdating();

    public void updateConfig(String var1, @Nullable String var2, String var3, String var4, boolean var5);

    public void checkForUpdates(IProgressMonitor var1);

    public boolean hasUpdates();

    public void updateModuleList(IProgressMonitor var1);

    public boolean isSonarCloud();

    public boolean areNotificationsEnabled();
}

