/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.resources;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.adapter.Adapters;
import org.sonarlint.eclipse.core.internal.utils.SonarLintUtils;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;

public class DefaultSonarLintProjectAdapter
implements ISonarLintProject {
    private static final String UNABLE_TO_ANALYZE_CHANGED_FILES = "Unable to collect changed files";
    private final IProject project;

    public DefaultSonarLintProjectAdapter(IProject project) {
        this.project = project;
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    @Override
    public Path getWorkingDir() {
        return this.project.getWorkingLocation("org.sonarlint.eclipse.core").toFile().toPath();
    }

    @Override
    public boolean exists(String relativeFilePath) {
        return this.project.getFile(relativeFilePath).exists();
    }

    @Override
    public Object getObjectToNotify() {
        return this.project;
    }

    @Override
    public Collection<ISonarLintFile> files() {
        final ArrayList<ISonarLintFile> result = new ArrayList<ISonarLintFile>();
        try {
            this.project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (!SonarLintUtils.shouldAnalyze(resource)) {
                        return false;
                    }
                    ISonarLintFile sonarLintFile = Adapters.adapt(resource, ISonarLintFile.class);
                    if (sonarLintFile != null) {
                        result.add(sonarLintFile);
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            SonarLintLogger.get().error("Error collecting files in project " + this.project.getName(), e);
        }
        return result;
    }

    public String getNoScmSupportCause() {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)this.project);
        if (provider == null) {
            return "No SCM for project '" + this.project.getName() + "'";
        }
        if (provider.getSubscriber() == null) {
            return "Unsupported SCM for project '" + this.project.getName() + "'";
        }
        return null;
    }

    public Collection<ISonarLintFile> getScmChangedFiles(IProgressMonitor monitor) {
        ArrayList<ISonarLintFile> result = new ArrayList<ISonarLintFile>();
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)this.project);
        if (provider == null) {
            SonarLintLogger.get().debug("Project " + this.project.getName() + " doesn't have any RepositoryProvider");
            return result;
        }
        Subscriber subscriber = provider.getSubscriber();
        if (subscriber == null) {
            SonarLintLogger.get().debug("No Subscriber for provider " + provider.getID() + " on project " + this.project.getName());
            return result;
        }
        try {
            IResource[] roots = subscriber.roots();
            if (Arrays.asList(roots).contains(this.project)) {
                subscriber.refresh(new IResource[]{this.project}, 2, monitor);
                DefaultSonarLintProjectAdapter.collect(subscriber, (IResource)this.project, result);
            } else {
                SonarLintLogger.get().debug("Project " + this.project.getName() + " is not part of Subscriber roots");
            }
        }
        catch (TeamException e) {
            throw new IllegalStateException(UNABLE_TO_ANALYZE_CHANGED_FILES, e);
        }
        return result;
    }

    private static void collect(Subscriber subscriber, IResource resource, Collection<ISonarLintFile> changedFiles) throws TeamException {
        IFile file = Adapters.adapt(resource, IFile.class);
        if (file != null) {
            SyncInfo syncInfo;
            ISonarLintFile sonarLintFile = Adapters.adapt(file, ISonarLintFile.class);
            if (sonarLintFile != null && (syncInfo = subscriber.getSyncInfo(resource)) != null && !SyncInfo.isInSync((int)syncInfo.getKind())) {
                changedFiles.add(sonarLintFile);
            }
        } else {
            IResource[] iResourceArray = subscriber.members(resource);
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                DefaultSonarLintProjectAdapter.collect(subscriber, child, changedFiles);
                ++n2;
            }
        }
    }

    @Override
    public ISonarLintProject getProject() {
        return this;
    }

    @Override
    public IResource getResource() {
        return this.project;
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultSonarLintProjectAdapter other = (DefaultSonarLintProjectAdapter)obj;
        return Objects.equals(this.project, other.project);
    }
}

