/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.notifications;

import java.util.HashMap;
import java.util.Map;
import org.sonarlint.eclipse.core.internal.StoragePathManager;
import org.sonarlint.eclipse.core.internal.notifications.NotificationsTracker;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;

public class NotificationsTrackerRegistry {
    private final Map<String, NotificationsTracker> registry = new HashMap<String, NotificationsTracker>();

    public synchronized NotificationsTracker getOrCreate(ISonarLintProject project) {
        String projectName = project.getName();
        NotificationsTracker tracker = this.registry.get(projectName);
        if (tracker == null) {
            tracker = NotificationsTrackerRegistry.newTracker(projectName);
            this.registry.put(projectName, tracker);
        }
        return tracker;
    }

    private static NotificationsTracker newTracker(String projectName) {
        return new NotificationsTracker(StoragePathManager.getNotificationsDir(projectName));
    }
}

