/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.markers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.PreferencesUtils;
import org.sonarlint.eclipse.core.internal.markers.TextRange;

public final class MarkerUtils {
    public static final String SONAR_MARKER_RULE_KEY_ATTR = "rulekey";
    public static final String SONAR_MARKER_RULE_NAME_ATTR = "rulename";
    public static final String SONAR_MARKER_ISSUE_SEVERITY_ATTR = "sonarseverity";
    public static final String SONAR_MARKER_ISSUE_TYPE_ATTR = "issuetype";
    public static final String SONAR_MARKER_CREATION_DATE_ATTR = "creationdate";
    public static final String SONAR_MARKER_SERVER_ISSUE_KEY_ATTR = "serverissuekey";
    public static final String SONAR_MARKER_HAS_EXTRA_LOCATION_KEY_ATTR = "hasextralocation";
    public static final String SONARLINT_EXTRA_POSITIONS_CATEGORY = "sonarlintextralocations";

    private MarkerUtils() {
    }

    public static List<IMarker> findOnTheFlyIssuesMarkers(IResource resource) {
        try {
            return Arrays.asList(resource.findMarkers("org.sonarlint.eclipse.core.sonarlintOnTheFlyProblem", true, 2));
        }
        catch (CoreException e) {
            SonarLintLogger.get().error(e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    public static List<IMarker> findReportIssuesMarkers(IResource resource) {
        try {
            return Arrays.asList(resource.findMarkers("org.sonarlint.eclipse.core.sonarlintReportProblem", true, 2));
        }
        catch (CoreException e) {
            SonarLintLogger.get().error(e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    public static void updateAllSonarMarkerSeverity() throws CoreException {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                IMarker[] iMarkerArray = project.findMarkers("org.sonarlint.eclipse.core.sonarlintOnTheFlyProblem", true, 2);
                int n3 = iMarkerArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMarker marker = iMarkerArray[n4];
                    marker.setAttribute("severity", PreferencesUtils.getMarkerSeverity());
                    ++n4;
                }
            }
            ++n2;
        }
    }

    @CheckForNull
    public static Position getPosition(IDocument document, @Nullable TextRange textRange) {
        if (textRange == null || textRange.getStartLine() == null) {
            return null;
        }
        if (textRange.getStartLineOffset() == null) {
            return MarkerUtils.getPosition(document, textRange.getStartLine());
        }
        return MarkerUtils.getPosition(document, textRange.getStartLine(), textRange.getStartLineOffset(), textRange.getEndLine(), textRange.getEndLineOffset());
    }

    @CheckForNull
    public static Position getPosition(IDocument document, int startLine) {
        String lineDelimiter;
        int length;
        int startLineStartOffset;
        try {
            startLineStartOffset = document.getLineOffset(startLine - 1);
            length = document.getLineLength(startLine - 1);
            lineDelimiter = document.getLineDelimiter(startLine - 1);
        }
        catch (BadLocationException e) {
            SonarLintLogger.get().error("failed to compute flat text range for line " + startLine, e);
            return null;
        }
        int lineDelimiterLength = lineDelimiter != null ? lineDelimiter.length() : 0;
        return new Position(startLineStartOffset, length - lineDelimiterLength);
    }

    @CheckForNull
    public static Position getPosition(IDocument document, int startLine, int startLineOffset, int endLine, int endLineOffset) {
        try {
            return MarkerUtils.convertToGlobalOffset(document, startLine, startLineOffset, endLine, endLineOffset, Position::new);
        }
        catch (BadLocationException e) {
            SonarLintLogger.get().error("failed to compute line offsets for start, end = " + startLine + ", " + endLine, e);
            return null;
        }
    }

    @CheckForNull
    public static ExtraPosition getExtraPosition(IDocument document, int startLine, int startLineOffset, int endLine, int endLineOffset, String message, long markerId, ExtraPosition parent) {
        try {
            return MarkerUtils.convertToGlobalOffset(document, startLine, startLineOffset, endLine, endLineOffset, (o, l2) -> new ExtraPosition((int)o, (int)l2, message, markerId, parent));
        }
        catch (BadLocationException e) {
            SonarLintLogger.get().error("failed to compute line offsets for start, end = " + startLine + ", " + endLine, e);
            return null;
        }
    }

    private static <G> G convertToGlobalOffset(IDocument document, int startLine, int startLineOffset, int endLine, int endLineOffset, BiFunction<Integer, Integer, G> function) throws BadLocationException {
        int startLineStartOffset = document.getLineOffset(startLine - 1);
        int endLineStartOffset = endLine != startLine ? document.getLineOffset(endLine - 1) : startLineStartOffset;
        int start = startLineStartOffset + startLineOffset;
        int end = endLineStartOffset + endLineOffset;
        return function.apply(start, end - start);
    }

    public static class ExtraPosition
    extends Position {
        private final String message;
        private final long markerId;
        private final ExtraPosition previous;

        public ExtraPosition(int offset, int length, @Nullable String message, long markerId, @Nullable ExtraPosition previous) {
            super(offset, length);
            this.message = message;
            this.markerId = markerId;
            this.previous = previous;
        }

        @CheckForNull
        public String getMessage() {
            return this.message;
        }

        public long getMarkerId() {
            return this.markerId;
        }

        @CheckForNull
        public ExtraPosition getParent() {
            return this.previous;
        }

        public boolean equals(Object other) {
            if (other instanceof ExtraPosition) {
                ExtraPosition rp = (ExtraPosition)((Object)other);
                return rp.offset == this.offset && rp.length == this.length && rp.markerId == this.markerId && Objects.equals(rp.message, this.message) && Objects.equals((Object)rp.previous, (Object)this.previous);
            }
            return super.equals(other);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (int)(this.markerId ^ this.markerId >>> 32);
            return result;
        }
    }
}

