/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.jobs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.internal.PreferencesUtils;
import org.sonarlint.eclipse.core.internal.TriggerType;
import org.sonarlint.eclipse.core.internal.markers.MarkerUtils;
import org.sonarlint.eclipse.core.internal.tracking.Trackable;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;
import org.sonarlint.eclipse.core.resource.ISonarLintIssuable;
import org.sonarsource.sonarlint.core.client.api.common.analysis.Issue;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueLocation;

public class SonarLintMarkerUpdater {
    private static final DefaultPositionUpdater EXTRA_POSITIONS_UPDATER = new DefaultPositionUpdater("sonarlintextralocations");

    private SonarLintMarkerUpdater() {
    }

    public static void createOrUpdateMarkers(ISonarLintFile issuable, IDocument document, Collection<Trackable> issues, TriggerType triggerType, boolean createExtraLocations) {
        try {
            Set<IMarker> previousMarkersToDelete = triggerType.isOnTheFly() ? new HashSet<IMarker>(Arrays.asList(issuable.getResource().findMarkers("org.sonarlint.eclipse.core.sonarlintOnTheFlyProblem", false, 0))) : Collections.emptySet();
            if (createExtraLocations) {
                SonarLintMarkerUpdater.resetExtraPositions(document);
            }
            SonarLintMarkerUpdater.createOrUpdateMarkers(document, issuable, issues, triggerType, previousMarkersToDelete, createExtraLocations);
            for (IMarker marker : previousMarkersToDelete) {
                marker.delete();
            }
        }
        catch (CoreException e) {
            SonarLintLogger.get().error(e.getMessage(), e);
        }
    }

    private static void resetExtraPositions(IDocument document) {
        try {
            document.removePositionCategory("sonarlintextralocations");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        document.addPositionCategory("sonarlintextralocations");
        document.addPositionUpdater((IPositionUpdater)EXTRA_POSITIONS_UPDATER);
    }

    public static void updateMarkersWithServerSideData(ISonarLintIssuable issuable, IDocument document, Collection<Trackable> issues, TriggerType triggerType, boolean createExtraLocations) {
        try {
            for (Trackable issue : issues) {
                SonarLintMarkerUpdater.updateMarkerWithServerSideData(issuable, document, issue, triggerType, createExtraLocations);
            }
        }
        catch (CoreException e) {
            SonarLintLogger.get().error(e.getMessage(), e);
        }
    }

    private static void updateMarkerWithServerSideData(ISonarLintIssuable issuable, IDocument document, Trackable issue, TriggerType triggerType, boolean createExtraLocations) throws CoreException {
        Long markerId = issue.getMarkerId();
        IMarker marker = null;
        if (markerId != null) {
            marker = issuable.getResource().findMarker(markerId.longValue());
        }
        if (issue.isResolved()) {
            if (marker != null) {
                marker.delete();
            }
            issue.setMarkerId(null);
        } else if (marker != null) {
            SonarLintMarkerUpdater.updateServerMarkerAttributes(issue, marker);
        } else {
            SonarLintMarkerUpdater.createMarker(document, issuable, issue, triggerType, createExtraLocations);
        }
    }

    private static void createOrUpdateMarkers(IDocument document, ISonarLintIssuable issuable, Collection<Trackable> issues, TriggerType triggerType, Set<IMarker> previousMarkersToDelete, boolean createExtraLocations) throws CoreException {
        for (Trackable issue : issues) {
            if (!issue.isResolved()) {
                if (!triggerType.isOnTheFly() || issue.getMarkerId() == null || issuable.getResource().findMarker(issue.getMarkerId().longValue()) == null) {
                    SonarLintMarkerUpdater.createMarker(document, issuable, issue, triggerType, createExtraLocations);
                    continue;
                }
                IMarker marker = issuable.getResource().findMarker(issue.getMarkerId().longValue());
                SonarLintMarkerUpdater.updateMarkerAttributes(document, issue, marker, createExtraLocations);
                previousMarkersToDelete.remove(marker);
                continue;
            }
            issue.setMarkerId(null);
        }
    }

    private static void createMarker(IDocument document, ISonarLintIssuable issuable, Trackable trackable, TriggerType triggerType, boolean createExtraLocations) throws CoreException {
        IMarker marker = issuable.getResource().createMarker(triggerType.isOnTheFly() ? "org.sonarlint.eclipse.core.sonarlintOnTheFlyProblem" : "org.sonarlint.eclipse.core.sonarlintReportProblem");
        if (triggerType.isOnTheFly()) {
            trackable.setMarkerId(marker.getId());
        }
        marker.setAttribute("org.eclipse.ui.views.markers.name", (Object)issuable.getResourceNameForMarker());
        marker.setAttribute("org.eclipse.ui.views.markers.path", (Object)issuable.getResourceContainerForMarker());
        SonarLintMarkerUpdater.updateMarkerAttributes(document, trackable, marker, createExtraLocations);
    }

    private static void updateMarkerAttributes(IDocument document, Trackable trackable, IMarker marker, boolean createExtraLocations) throws CoreException {
        Map existingAttributes = marker.getAttributes();
        SonarLintMarkerUpdater.setMarkerAttributeIfDifferent(marker, existingAttributes, "rulekey", trackable.getRuleKey());
        SonarLintMarkerUpdater.setMarkerAttributeIfDifferent(marker, existingAttributes, "rulename", trackable.getRuleName());
        SonarLintMarkerUpdater.setMarkerAttributeIfDifferent(marker, existingAttributes, "severity", PreferencesUtils.getMarkerSeverity());
        SonarLintMarkerUpdater.setMarkerAttributeIfDifferent(marker, existingAttributes, "message", trackable.getMessage());
        SonarLintMarkerUpdater.setMarkerAttributeIfDifferent(marker, existingAttributes, "lineNumber", trackable.getLine() != null ? trackable.getLine() : 1);
        Position position = MarkerUtils.getPosition(document, trackable.getTextRange());
        if (position != null) {
            SonarLintMarkerUpdater.setMarkerAttributeIfDifferent(marker, existingAttributes, "charStart", position.getOffset());
            SonarLintMarkerUpdater.setMarkerAttributeIfDifferent(marker, existingAttributes, "charEnd", position.getOffset() + position.getLength());
        }
        boolean hasExtraLocation = false;
        if (createExtraLocations) {
            hasExtraLocation = SonarLintMarkerUpdater.createExtraLocations(document, trackable, marker);
        }
        SonarLintMarkerUpdater.setMarkerAttributeIfDifferent(marker, existingAttributes, "hasextralocation", hasExtraLocation);
        SonarLintMarkerUpdater.updateServerMarkerAttributes(trackable, marker);
    }

    private static boolean createExtraLocations(IDocument document, Trackable trackable, IMarker marker) {
        boolean hasExtraLocation = false;
        for (Issue.Flow f : trackable.getFlows()) {
            MarkerUtils.ExtraPosition parent = null;
            ArrayList locations = new ArrayList(f.locations());
            Collections.reverse(locations);
            for (IssueLocation l : locations) {
                MarkerUtils.ExtraPosition extraPosition = MarkerUtils.getExtraPosition(document, l.getStartLine(), l.getStartLineOffset(), l.getEndLine(), l.getEndLineOffset(), l.getMessage(), marker.getId(), parent);
                if (extraPosition == null) continue;
                SonarLintMarkerUpdater.savePosition(document, extraPosition);
                parent = extraPosition;
                hasExtraLocation = true;
            }
        }
        return hasExtraLocation;
    }

    private static void savePosition(IDocument document, MarkerUtils.ExtraPosition extraPosition) {
        try {
            document.addPosition("sonarlintextralocations", (Position)extraPosition);
        }
        catch (BadLocationException | BadPositionCategoryException e) {
            throw new IllegalStateException("Unable to register extra position", e);
        }
    }

    private static void updateServerMarkerAttributes(Trackable trackable, IMarker marker) throws CoreException {
        Map existingAttributes = marker.getAttributes();
        SonarLintMarkerUpdater.setMarkerAttributeIfDifferent(marker, existingAttributes, "priority", SonarLintMarkerUpdater.getPriority(trackable.getSeverity()));
        SonarLintMarkerUpdater.setMarkerAttributeIfDifferent(marker, existingAttributes, "sonarseverity", trackable.getSeverity());
        SonarLintMarkerUpdater.setMarkerAttributeIfDifferent(marker, existingAttributes, "issuetype", trackable.getType());
        SonarLintMarkerUpdater.setMarkerAttributeIfDifferent(marker, existingAttributes, "serverissuekey", trackable.getServerIssueKey());
        Long creationDate = trackable.getCreationDate();
        SonarLintMarkerUpdater.setMarkerAttributeIfDifferent(marker, existingAttributes, "creationdate", creationDate != null ? String.valueOf(creationDate) : null);
    }

    private static void setMarkerAttributeIfDifferent(IMarker marker, @Nullable Map<String, Object> existingAttributes, String attributeName, @Nullable Object value) throws CoreException {
        if (!Objects.equals(value, existingAttributes != null ? existingAttributes.get(attributeName) : null)) {
            marker.setAttribute(attributeName, value);
        }
    }

    /*
     * Exception decompiling
     */
    private static int getPriority(String severity) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl37 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl37 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

