/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProjectConfiguration;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;

public class ProjectUpdateJob
extends Job {
    private final ISonarLintProject project;

    public ProjectUpdateJob(ISonarLintProject project) {
        super("Update configuration of project " + project.getName());
        this.project = project;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            SonarLintProjectConfiguration config = SonarLintProjectConfiguration.read(this.project.getScopeContext());
            String serverId = config.getServerId();
            IServer server = SonarLintCorePlugin.getServersManager().getServer(serverId);
            if (server == null) {
                return new Status(4, "org.sonarlint.eclipse.core", "Unable to update project '" + this.project.getName() + "' since it is bound to an unknow server: '" + serverId + "'");
            }
            server.updateProjectStorage(config.getModuleKey(), monitor);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, "org.sonarlint.eclipse.core", "Unable to update project " + this.project.getName(), (Throwable)e);
        }
    }
}

