/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.jobs;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.analysis.IPreAnalysisContext;
import org.sonarlint.eclipse.core.internal.jobs.EclipseInputFile;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarsource.sonarlint.core.client.api.common.analysis.ClientInputFile;

public class DefaultPreAnalysisContext
implements IPreAnalysisContext {
    private static final String SEPARATOR = ",";
    private final ISonarLintProject project;
    private final Map<String, String> analysisProperties;
    private final Map<ISonarLintFile, String> filesToAnalyze;
    private final Path tempDir;

    public DefaultPreAnalysisContext(ISonarLintProject project, Map<String, String> analysisProperties, List<ClientInputFile> filesToAnalyze, Path tempDir) {
        this.project = project;
        this.analysisProperties = analysisProperties;
        this.tempDir = tempDir;
        this.filesToAnalyze = Collections.unmodifiableMap(filesToAnalyze.stream().map(EclipseInputFile.class::cast).collect(Collectors.toMap(EclipseInputFile::getClientObject, EclipseInputFile::getPath)));
    }

    @Override
    public ISonarLintProject getProject() {
        return this.project;
    }

    @Override
    public void setAnalysisProperty(String key, String value) {
        if (this.analysisProperties.containsKey(key)) {
            SonarLintLogger.get().debug("Property '" + key + "' was already set to value '" + this.analysisProperties.get(key) + "' and will be overriden by '" + value + "'");
        }
        this.analysisProperties.put(key, value);
    }

    @Override
    public void setAnalysisProperty(String key, Collection<String> values) {
        this.setAnalysisProperty(key, StringUtils.joinSkipNull(values, SEPARATOR));
    }

    @Override
    public Collection<ISonarLintFile> getFilesToAnalyze() {
        return this.filesToAnalyze.keySet();
    }

    public String getLocalPath(ISonarLintFile file) {
        return this.filesToAnalyze.get(file);
    }

    @Override
    public Path getAnalysisTemporaryFolder() {
        return this.tempDir;
    }
}

