/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.jobs;

import java.lang.invoke.LambdaMetafactory;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.sonarlint.eclipse.core.SonarLintLogger;
import org.sonarlint.eclipse.core.analysis.IAnalysisConfigurator;
import org.sonarlint.eclipse.core.analysis.IFileLanguageProvider;
import org.sonarlint.eclipse.core.analysis.IPostAnalysisContext;
import org.sonarlint.eclipse.core.configurator.ProjectConfigurationRequest;
import org.sonarlint.eclipse.core.configurator.ProjectConfigurator;
import org.sonarlint.eclipse.core.internal.PreferencesUtils;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.TriggerType;
import org.sonarlint.eclipse.core.internal.jobs.AbstractSonarProjectJob;
import org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectRequest;
import org.sonarlint.eclipse.core.internal.jobs.DefaultPreAnalysisContext;
import org.sonarlint.eclipse.core.internal.jobs.EclipseInputFile;
import org.sonarlint.eclipse.core.internal.jobs.SonarLintIssueListener;
import org.sonarlint.eclipse.core.internal.jobs.SonarLintMarkerUpdater;
import org.sonarlint.eclipse.core.internal.jobs.StandaloneSonarLintClientFacade;
import org.sonarlint.eclipse.core.internal.markers.MarkerUtils;
import org.sonarlint.eclipse.core.internal.markers.TextRange;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProperty;
import org.sonarlint.eclipse.core.internal.server.IServer;
import org.sonarlint.eclipse.core.internal.server.Server;
import org.sonarlint.eclipse.core.internal.tracking.IssueTracker;
import org.sonarlint.eclipse.core.internal.tracking.RawIssueTrackable;
import org.sonarlint.eclipse.core.internal.tracking.ServerIssueTrackable;
import org.sonarlint.eclipse.core.internal.tracking.ServerIssueUpdater;
import org.sonarlint.eclipse.core.internal.tracking.Trackable;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;
import org.sonarlint.eclipse.core.resource.ISonarLintIssuable;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarsource.sonarlint.core.client.api.common.analysis.AnalysisResults;
import org.sonarsource.sonarlint.core.client.api.common.analysis.ClientInputFile;
import org.sonarsource.sonarlint.core.client.api.common.analysis.Issue;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.connected.ConnectedSonarLintEngine;
import org.sonarsource.sonarlint.core.client.api.connected.ServerConfiguration;
import org.sonarsource.sonarlint.core.client.api.exceptions.CanceledException;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.util.FileUtils;

public class AnalyzeProjectJob
extends AbstractSonarProjectJob {
    private final List<SonarLintProperty> extraProps;
    private final AnalyzeProjectRequest request;

    public AnalyzeProjectJob(AnalyzeProjectRequest request) {
        super(AnalyzeProjectJob.jobTitle(request), request.getProject());
        this.request = request;
        this.extraProps = PreferencesUtils.getExtraPropertiesForLocalAnalysis(request.getProject());
    }

    private static String jobTitle(AnalyzeProjectRequest request) {
        if (request.getFiles() == null) {
            return "SonarLint analysis of project " + request.getProject().getName();
        }
        if (request.getFiles().size() == 1) {
            return "SonarLint analysis of file " + request.getFiles().iterator().next().getFile().getName();
        }
        return "SonarLint analysis of project " + request.getProject().getName() + " (" + request.getFiles().size() + " files)";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected IStatus doRun(IProgressMonitor monitor) {
        block14: {
            block12: {
                block13: {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    startTime = System.currentTimeMillis();
                    SonarLintLogger.get().debug("Trigger: " + this.request.getTriggerType().name());
                    SonarLintLogger.get().info(String.valueOf(this.getName()) + "...");
                    analysisWorkDir = null;
                    mergedExtraProps = new LinkedHashMap<String, String>();
                    filesToAnalyze = this.request.getFiles().stream().collect((Supplier<HashMap>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/util/HashMap;)(), (BiConsumer<HashMap, AnalyzeProjectRequest.FileWithDocument>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$0(java.util.HashMap org.sonarlint.eclipse.core.internal.jobs.AnalyzeProjectRequest$FileWithDocument ), (Ljava/util/HashMap;Lorg/sonarlint/eclipse/core/internal/jobs/AnalyzeProjectRequest$FileWithDocument;)V)(), (BiConsumer<HashMap, HashMap>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, putAll(java.util.Map<? extends K, ? extends V> ), (Ljava/util/HashMap;Ljava/util/HashMap;)V)());
                    usedDeprecatedConfigurators = AnalyzeProjectJob.configureDeprecated(this.getProject(), filesToAnalyze.keySet(), mergedExtraProps, monitor);
                    analysisWorkDir = Files.createTempDirectory(this.getProject().getWorkingDir(), "sonarlint", new FileAttribute[0]);
                    inputFiles = AnalyzeProjectJob.buildInputFiles(analysisWorkDir, filesToAnalyze);
                    usedConfigurators = AnalyzeProjectJob.configure(this.getProject(), inputFiles, mergedExtraProps, analysisWorkDir, monitor);
                    for (SonarLintProperty sonarProperty : this.extraProps) {
                        mergedExtraProps.put(sonarProperty.getName(), sonarProperty.getValue());
                    }
                    if (inputFiles.isEmpty()) ** GOTO lbl30
                    server = null;
                    if (!this.getProject().isBound() || (server = (Server)SonarLintCorePlugin.getServersManager().getServer(this.getProjectConfig().getServerId())) != null) break block12;
                    var13_12 = new Status(4, "org.sonarlint.eclipse.core", "Project '" + this.getProject().getName() + "' is bound to an unknown SonarQube server: '" + this.getProjectConfig().getServerId() + "'. Please fix project binding or unbind project.");
                    if (analysisWorkDir == null) break block13;
                    FileUtils.deleteRecursively((Path)analysisWorkDir);
                }
                return var13_12;
            }
            try {
                this.runAnalysisAndUpdateMarkers(server, filesToAnalyze, monitor, mergedExtraProps, inputFiles, analysisWorkDir);
lbl30:
                // 2 sources

                AnalyzeProjectJob.analysisCompleted(usedDeprecatedConfigurators, usedConfigurators, mergedExtraProps, monitor);
                SonarLintCorePlugin.getAnalysisListenerManager().notifyListeners();
                SonarLintLogger.get().debug(String.format("Done in %d ms", new Object[]{System.currentTimeMillis() - startTime}));
            }
            catch (CanceledException v0) {
                var13_13 = Status.CANCEL_STATUS;
                if (analysisWorkDir != null) {
                    FileUtils.deleteRecursively(analysisWorkDir);
                }
                return var13_13;
            }
            catch (Exception e) {
                try {
                    SonarLintLogger.get().error("Error during execution of SonarLint analysis", e);
                    var13_14 = new Status(2, "org.sonarlint.eclipse.core", "Error when executing SonarLint analysis", (Throwable)e);
                    return var13_14;
                }
                catch (Throwable var12_15) {
                    throw var12_15;
                }
                finally {
                    if (analysisWorkDir != null) {
                        FileUtils.deleteRecursively(analysisWorkDir);
                    }
                }
            }
            if (analysisWorkDir == null) break block14;
            FileUtils.deleteRecursively((Path)analysisWorkDir);
        }
        return monitor.isCanceled() != false ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    private void runAnalysisAndUpdateMarkers(@Nullable Server server, Map<ISonarLintFile, IDocument> docPerFiles, IProgressMonitor monitor, Map<String, String> mergedExtraProps, List<ClientInputFile> inputFiles, Path analysisWorkDir) throws CoreException {
        StandaloneAnalysisConfiguration config;
        Path projectBaseDir;
        IPath projectLocation = this.getProject().getResource().getLocation();
        Path path = projectBaseDir = projectLocation != null ? projectLocation.toFile().toPath() : analysisWorkDir;
        if (server != null) {
            SonarLintLogger.get().debug("Connected mode (using configuration of '" + this.getProjectConfig().getModuleKey() + "' in server '" + this.getProjectConfig().getServerId() + "')");
            config = new ConnectedAnalysisConfiguration(StringUtils.trimToNull(this.getProjectConfig().getModuleKey()), projectBaseDir, this.getProject().getWorkingDir(), inputFiles, mergedExtraProps);
        } else {
            SonarLintLogger.get().debug("Standalone mode (project not bound)");
            config = new StandaloneAnalysisConfiguration(projectBaseDir, this.getProject().getWorkingDir(), inputFiles, mergedExtraProps);
        }
        LinkedHashMap<ISonarLintIssuable, List<Issue>> issuesPerResource = new LinkedHashMap<ISonarLintIssuable, List<Issue>>();
        this.request.getFiles().forEach(fileWithDoc -> {
            ArrayList arrayList = issuesPerResource.put(fileWithDoc.getFile(), new ArrayList());
        });
        AnalysisResults result = this.run(server, config, issuesPerResource, monitor);
        if (!monitor.isCanceled() && result != null) {
            this.updateMarkers(server, docPerFiles, issuesPerResource, result, this.request.getTriggerType(), monitor);
        }
    }

    private static List<ClientInputFile> buildInputFiles(Path tempDirectory, Map<ISonarLintFile, IDocument> filesToAnalyze) {
        ArrayList<ClientInputFile> inputFiles = new ArrayList<ClientInputFile>(filesToAnalyze.size());
        String allTestPattern = PreferencesUtils.getTestFileRegexps();
        String[] testPatterns = allTestPattern.split(",");
        List<PathMatcher> pathMatchersForTests = AnalyzeProjectJob.createMatchersForTests(testPatterns);
        for (Map.Entry<ISonarLintFile, IDocument> fileWithDoc : filesToAnalyze.entrySet()) {
            ISonarLintFile file = fileWithDoc.getKey();
            String language = AnalyzeProjectJob.tryDetectLanguage(file);
            EclipseInputFile inputFile = new EclipseInputFile(pathMatchersForTests, file, tempDirectory, fileWithDoc.getValue(), language);
            inputFiles.add(inputFile);
        }
        return inputFiles;
    }

    @CheckForNull
    private static String tryDetectLanguage(ISonarLintFile file) {
        String language = null;
        for (IFileLanguageProvider languageProvider : SonarLintCorePlugin.getExtensionTracker().getLanguageProviders()) {
            String detectedLanguage = languageProvider.language(file);
            if (detectedLanguage == null) continue;
            if (language == null) {
                language = detectedLanguage;
                continue;
            }
            if (language.equals(detectedLanguage)) continue;
            SonarLintLogger.get().error("Conflicting languages detected for file " + file.getName() + ". " + language + " and " + detectedLanguage);
        }
        return language;
    }

    private static List<PathMatcher> createMatchersForTests(String[] testPatterns) {
        ArrayList<PathMatcher> pathMatchersForTests = new ArrayList<PathMatcher>();
        FileSystem fs = FileSystems.getDefault();
        String[] stringArray = testPatterns;
        int n = testPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String testPattern = stringArray[n2];
            pathMatchersForTests.add(fs.getPathMatcher("glob:" + testPattern));
            ++n2;
        }
        return pathMatchersForTests;
    }

    private static Collection<ProjectConfigurator> configureDeprecated(ISonarLintProject project, Collection<ISonarLintFile> filesToAnalyze, Map<String, String> extraProperties, IProgressMonitor monitor) {
        ArrayList<ProjectConfigurator> usedConfigurators = new ArrayList<ProjectConfigurator>();
        if (project.getResource() instanceof IProject) {
            ProjectConfigurationRequest configuratorRequest = new ProjectConfigurationRequest((IProject)project.getResource(), filesToAnalyze.stream().map(f -> f.getResource() instanceof IFile ? (IFile)f.getResource() : null).filter(Objects::nonNull).collect(Collectors.toList()), extraProperties);
            Collection<ProjectConfigurator> configurators = SonarLintCorePlugin.getExtensionTracker().getConfigurators();
            for (ProjectConfigurator configurator : configurators) {
                if (!configurator.canConfigure((IProject)project.getResource())) continue;
                configurator.configure(configuratorRequest, monitor);
                usedConfigurators.add(configurator);
            }
        }
        return usedConfigurators;
    }

    private static Collection<IAnalysisConfigurator> configure(ISonarLintProject project, List<ClientInputFile> filesToAnalyze, Map<String, String> extraProperties, Path tempDir, IProgressMonitor monitor) {
        ArrayList<IAnalysisConfigurator> usedConfigurators = new ArrayList<IAnalysisConfigurator>();
        Collection<IAnalysisConfigurator> configurators = SonarLintCorePlugin.getExtensionTracker().getAnalysisConfigurators();
        DefaultPreAnalysisContext context = new DefaultPreAnalysisContext(project, extraProperties, filesToAnalyze, tempDir);
        for (IAnalysisConfigurator configurator : configurators) {
            if (!configurator.canConfigure(project)) continue;
            configurator.configure(context, monitor);
            usedConfigurators.add(configurator);
        }
        return usedConfigurators;
    }

    private void updateMarkers(@Nullable Server server, Map<ISonarLintFile, IDocument> docPerFile, Map<ISonarLintIssuable, List<Issue>> issuesPerResource, AnalysisResults result, TriggerType triggerType, IProgressMonitor monitor) throws CoreException {
        Set failedFiles = result.failedAnalysisFiles().stream().map(ClientInputFile::getClientObject).collect(Collectors.toSet());
        Map<ISonarLintIssuable, List<Issue>> successfulFiles = issuesPerResource.entrySet().stream().filter(e -> !failedFiles.contains(e.getKey())).filter(e -> e.getKey() instanceof ISonarLintFile).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.trackIssues(server, docPerFile, successfulFiles, triggerType, monitor);
    }

    private void trackIssues(@Nullable Server server, Map<ISonarLintFile, IDocument> docPerFile, Map<ISonarLintIssuable, List<Issue>> rawIssuesPerResource, TriggerType triggerType, IProgressMonitor monitor) {
        List<ISonarLintIssuable> filesWithAtLeastOneIssue;
        String localModuleKey = this.getProject().getName();
        if (server != null && triggerType.shouldUpdateProjectIssuesSync(rawIssuesPerResource.size())) {
            ServerConfiguration serverConfiguration = server.getConfig();
            ConnectedSonarLintEngine engine = server.getEngine();
            SonarLintLogger.get().debug("Download server issues for project " + this.getProject().getName());
            engine.downloadServerIssues(serverConfiguration, this.getProjectConfig().getModuleKey());
        }
        for (Map.Entry<ISonarLintIssuable, List<Issue>> entry : rawIssuesPerResource.entrySet()) {
            if (monitor.isCanceled()) {
                return;
            }
            ISonarLintFile resource = (ISonarLintFile)entry.getKey();
            IDocument documentOrNull = docPerFile.get(resource);
            IDocument documentNotNull = documentOrNull == null ? resource.getDocument() : documentOrNull;
            List<Issue> rawIssues = entry.getValue();
            List<Trackable> trackables = rawIssues.stream().map(issue -> AnalyzeProjectJob.transform(issue, resource, documentNotNull)).collect(Collectors.toList());
            IssueTracker issueTracker = SonarLintCorePlugin.getOrCreateIssueTracker(this.getProject(), localModuleKey);
            String relativePath = resource.getProjectRelativePath();
            Collection<Trackable> tracked = issueTracker.matchAndTrackAsNew(relativePath, trackables);
            if (server != null && !tracked.isEmpty()) {
                tracked = this.trackServerIssuesSync(server, resource, tracked, triggerType.shouldUpdateFileIssuesSync(rawIssuesPerResource.size()));
            }
            ISchedulingRule markerRule = ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(resource.getResource());
            try {
                AnalyzeProjectJob.getJobManager().beginRule(markerRule, monitor);
                SonarLintMarkerUpdater.createOrUpdateMarkers(resource, documentNotNull, tracked, triggerType, documentOrNull != null);
            }
            finally {
                AnalyzeProjectJob.getJobManager().endRule(markerRule);
            }
            issueTracker.updateCache(relativePath, tracked);
        }
        if (server != null && triggerType.shouldUpdateFileIssuesAsync() && !(filesWithAtLeastOneIssue = AnalyzeProjectJob.filesWithAtLeastOneIssue(rawIssuesPerResource)).isEmpty()) {
            this.trackServerIssuesAsync(server, filesWithAtLeastOneIssue, docPerFile, triggerType);
        }
    }

    private static List<ISonarLintIssuable> filesWithAtLeastOneIssue(Map<ISonarLintIssuable, List<Issue>> rawIssuesPerResource) {
        return rawIssuesPerResource.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private static RawIssueTrackable transform(Issue issue, ISonarLintFile resource, IDocument document) {
        Integer startLine = issue.getStartLine();
        if (startLine == null) {
            return new RawIssueTrackable(issue);
        }
        TextRange textRange = new TextRange(startLine, issue.getStartLineOffset(), issue.getEndLine(), issue.getEndLineOffset());
        String textRangeContent = AnalyzeProjectJob.readTextRangeContent(resource, document, textRange);
        String lineContent = AnalyzeProjectJob.readLineContent(resource, document, startLine);
        return new RawIssueTrackable(issue, textRange, textRangeContent, lineContent);
    }

    @CheckForNull
    private static String readTextRangeContent(ISonarLintFile resource, IDocument document, TextRange textRange) {
        Position position = MarkerUtils.getPosition(document, textRange);
        if (position != null) {
            try {
                return document.get(position.getOffset(), position.getLength());
            }
            catch (BadLocationException e) {
                SonarLintLogger.get().error("failed to get text range content of resource " + resource.getName(), e);
            }
        }
        return null;
    }

    @CheckForNull
    private static String readLineContent(ISonarLintFile resource, IDocument document, int startLine) {
        Position position = MarkerUtils.getPosition(document, startLine);
        if (position != null) {
            try {
                return document.get(position.getOffset(), position.getLength());
            }
            catch (BadLocationException e) {
                SonarLintLogger.get().error("Failed to get line content of file " + resource.getName(), e);
            }
        }
        return null;
    }

    private Collection<Trackable> trackServerIssuesSync(Server server, ISonarLintFile resource, Collection<Trackable> tracked, boolean updateServerIssues) {
        ServerConfiguration serverConfiguration = server.getConfig();
        ConnectedSonarLintEngine engine = server.getEngine();
        List serverIssues = updateServerIssues ? ServerIssueUpdater.fetchServerIssues(serverConfiguration, engine, this.getProjectConfig().getModuleKey(), resource) : engine.getServerIssues(this.getProjectConfig().getModuleKey(), resource.getProjectRelativePath());
        Collection serverIssuesTrackable = serverIssues.stream().map(ServerIssueTrackable::new).collect(Collectors.toList());
        return IssueTracker.matchAndTrackServerIssues(serverIssuesTrackable, tracked);
    }

    private void trackServerIssuesAsync(Server server, Collection<ISonarLintIssuable> resources, Map<ISonarLintFile, IDocument> docPerFile, TriggerType triggerType) {
        ServerConfiguration serverConfiguration = server.getConfig();
        ConnectedSonarLintEngine engine = server.getEngine();
        String localModuleKey = this.getProject().getName();
        SonarLintCorePlugin.getInstance().getServerIssueUpdater().updateAsync(serverConfiguration, engine, this.getProject(), localModuleKey, this.getProjectConfig().getModuleKey(), resources, docPerFile, triggerType);
    }

    private static void analysisCompleted(Collection<ProjectConfigurator> usedDeprecatedConfigurators, Collection<IAnalysisConfigurator> usedConfigurators, Map<String, String> properties, IProgressMonitor monitor) {
        final Map<String, String> unmodifiableMap = Collections.unmodifiableMap(properties);
        for (ProjectConfigurator p : usedDeprecatedConfigurators) {
            p.analysisComplete(unmodifiableMap, monitor);
        }
        IPostAnalysisContext context = new IPostAnalysisContext(){

            @Override
            public ISonarLintProject getProject() {
                return this.getProject();
            }

            @Override
            public Map<String, String> getAnalysisProperties() {
                return unmodifiableMap;
            }
        };
        for (IAnalysisConfigurator p : usedConfigurators) {
            p.analysisComplete(context, monitor);
        }
    }

    @CheckForNull
    public AnalysisResults run(@Nullable IServer server, StandaloneAnalysisConfiguration analysisConfig, Map<ISonarLintIssuable, List<Issue>> issuesPerResource, IProgressMonitor monitor) {
        AnalysisResults result;
        SonarLintLogger.get().debug("Starting analysis with configuration:\n" + analysisConfig.toString());
        SonarLintIssueListener issueListener = new SonarLintIssueListener(this.getProject(), issuesPerResource);
        if (server != null) {
            result = server.runAnalysis((ConnectedAnalysisConfiguration)analysisConfig, issueListener, monitor);
        } else {
            StandaloneSonarLintClientFacade facadeToUse = SonarLintCorePlugin.getInstance().getDefaultSonarLintClientFacade();
            result = facadeToUse.runAnalysis(analysisConfig, issueListener, monitor);
        }
        SonarLintLogger.get().info("Found " + issueListener.getIssueCount() + " issue(s)");
        return result;
    }

    private static /* synthetic */ void lambda$0(HashMap m, AnalyzeProjectRequest.FileWithDocument fWithDoc) {
        IDocument iDocument = m.put(fWithDoc.getFile(), fWithDoc.getDocument());
    }
}

