/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.adapter;

import java.util.function.Predicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.sonarlint.eclipse.core.internal.SonarLintCorePlugin;
import org.sonarlint.eclipse.core.internal.resources.DefaultSonarLintFileAdapter;
import org.sonarlint.eclipse.core.internal.resources.DefaultSonarLintProjectAdapter;
import org.sonarlint.eclipse.core.internal.utils.SonarLintUtils;
import org.sonarlint.eclipse.core.resource.ISonarLintFile;
import org.sonarlint.eclipse.core.resource.ISonarLintFileAdapterParticipant;
import org.sonarlint.eclipse.core.resource.ISonarLintIssuable;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;
import org.sonarlint.eclipse.core.resource.ISonarLintProjectAdapterParticipant;

public class DefaultSonarLintAdapterFactory
implements IAdapterFactory {
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        IProject project;
        if (!(adaptableObject instanceof IAdaptable)) {
            return null;
        }
        if ((ISonarLintProject.class.equals(adapterType) || ISonarLintIssuable.class.equals(adapterType)) && (project = (IProject)((IAdaptable)adaptableObject).getAdapter(IProject.class)) != null) {
            return this.getProjectAdapter(adapterType, project);
        }
        if (ISonarLintFile.class.equals(adapterType) || ISonarLintIssuable.class.equals(adapterType)) {
            IFile file = (IFile)((IAdaptable)adaptableObject).getAdapter(IFile.class);
            if (file != null) {
                return this.getFileAdapter(adapterType, file);
            }
            IResource resource = (IResource)((IAdaptable)adaptableObject).getAdapter(IResource.class);
            if (resource instanceof IFile) {
                return this.getFileAdapter(adapterType, (IFile)resource);
            }
        }
        return null;
    }

    private <T> T getProjectAdapter(Class<T> adapterType, IProject project) {
        Predicate<IProject> shouldExclude = SonarLintCorePlugin.getExtensionTracker().getProjectAdapterParticipants().stream().map(participant -> participant::exclude).reduce(Predicate::or).orElse(x -> false);
        if (shouldExclude.test(project)) {
            return null;
        }
        for (ISonarLintProjectAdapterParticipant p : SonarLintCorePlugin.getExtensionTracker().getProjectAdapterParticipants()) {
            ISonarLintProject adapted = p.adapt(project);
            if (adapted == null) continue;
            return adapterType.cast(adapted);
        }
        return adapterType.cast(new DefaultSonarLintProjectAdapter(project));
    }

    private <T> T getFileAdapter(Class<T> adapterType, IFile file) {
        if (!SonarLintUtils.shouldAnalyze((IResource)file)) {
            return null;
        }
        Predicate<IFile> shouldExclude = SonarLintCorePlugin.getExtensionTracker().getFileAdapterParticipants().stream().map(participant -> participant::exclude).reduce(Predicate::or).orElse(x -> false);
        if (shouldExclude.test(file)) {
            return null;
        }
        for (ISonarLintFileAdapterParticipant p : SonarLintCorePlugin.getExtensionTracker().getFileAdapterParticipants()) {
            ISonarLintFile adapted = p.adapt(file);
            if (adapted == null) continue;
            return adapterType.cast(adapted);
        }
        ISonarLintProject project = (ISonarLintProject)file.getProject().getAdapter(ISonarLintProject.class);
        return project != null ? (T)adapterType.cast(new DefaultSonarLintFileAdapter(project, file)) : null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{ISonarLintProject.class, ISonarLintFile.class, ISonarLintIssuable.class};
    }
}

