/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal.adapter;

import javax.annotation.Nullable;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;

public class Adapters {
    public static <T> T adapt(@Nullable Object sourceObject, Class<T> adapter, boolean allowActivation) {
        IAdaptable adaptable;
        Object result;
        if (sourceObject == null) {
            return null;
        }
        if (adapter.isInstance(sourceObject)) {
            return (T)sourceObject;
        }
        if (sourceObject instanceof IAdaptable && (result = (adaptable = (IAdaptable)sourceObject).getAdapter(adapter)) != null) {
            if (!adapter.isInstance(result)) {
                throw new AssertionFailedException(String.valueOf(adaptable.getClass().getName()) + ".getAdapter(" + adapter.getName() + ".class) returned " + result.getClass().getName() + " that is not an instance the requested type");
            }
            return (T)result;
        }
        if (sourceObject instanceof PlatformObject && !allowActivation) {
            return null;
        }
        String adapterId = adapter.getName();
        result = Adapters.queryAdapterManager(sourceObject, adapterId, allowActivation);
        if (result != null) {
            if (!adapter.isInstance(result)) {
                throw new AssertionFailedException("An adapter factory for " + sourceObject.getClass().getName() + " returned " + result.getClass().getName() + " that is not an instance of " + adapter.getName());
            }
            return (T)result;
        }
        return null;
    }

    public static <T> T adapt(Object sourceObject, Class<T> adapter) {
        return Adapters.adapt(sourceObject, adapter, true);
    }

    private static Object queryAdapterManager(Object sourceObject, String adapterId, boolean allowActivation) {
        Object result = allowActivation ? Platform.getAdapterManager().loadAdapter(sourceObject, adapterId) : Platform.getAdapterManager().getAdapter(sourceObject, adapterId);
        return result;
    }
}

