/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal;

public enum TriggerType {
    STARTUP("Startup", ServerIssueUpdateStrategy.PER_FILE_ASYNC),
    EDITOR_OPEN("Editor open", ServerIssueUpdateStrategy.PER_FILE_ASYNC),
    MANUAL("Manual trigger", ServerIssueUpdateStrategy.PER_PROJECT_OR_PER_FILE_SYNC),
    MANUAL_CHANGESET("Manual trigger changeset", ServerIssueUpdateStrategy.PER_PROJECT_OR_PER_FILE_SYNC),
    EDITOR_CHANGE("Editor change", ServerIssueUpdateStrategy.NO_UPDATE),
    BINDING_CHANGE("Binding change", ServerIssueUpdateStrategy.PER_FILE_ASYNC);

    private static final int PER_FILE_THRESHOLD = 10;
    private final String name;
    private final ServerIssueUpdateStrategy updateStrategy;

    private TriggerType(String name, ServerIssueUpdateStrategy updateStrategy) {
        this.name = name;
        this.updateStrategy = updateStrategy;
    }

    public String getName() {
        return this.name;
    }

    public boolean shouldUpdateFileIssuesAsync() {
        return this.updateStrategy == ServerIssueUpdateStrategy.PER_FILE_ASYNC;
    }

    public boolean shouldUpdateFileIssuesSync(int fileCount) {
        return this.updateStrategy == ServerIssueUpdateStrategy.PER_PROJECT_OR_PER_FILE_SYNC && fileCount < 10;
    }

    public boolean shouldUpdateProjectIssuesSync(int fileCount) {
        return this.updateStrategy == ServerIssueUpdateStrategy.PER_PROJECT_OR_PER_FILE_SYNC && fileCount >= 10;
    }

    public boolean isOnTheFly() {
        return this != MANUAL && this != MANUAL_CHANGESET;
    }

    private static enum ServerIssueUpdateStrategy {
        NO_UPDATE,
        PER_PROJECT_OR_PER_FILE_SYNC,
        PER_FILE_ASYNC;

    }
}

