/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal;

import java.nio.file.Path;
import org.eclipse.core.resources.ResourcesPlugin;

public class StoragePathManager {
    private StoragePathManager() {
    }

    private static Path getSonarLintUserHome() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().append(".sonarlint").toFile().toPath();
    }

    public static Path getServerWorkDir(String serverId) {
        return StoragePathManager.getSonarLintUserHome().resolve("work").resolve(serverId);
    }

    public static Path getServerStorageRoot() {
        return StoragePathManager.getSonarLintUserHome().resolve("storage");
    }

    private static Path getModuleStorageDir(String localModuleKey) {
        return StoragePathManager.getSonarLintUserHome().resolve("modules").resolve(localModuleKey);
    }

    public static Path getIssuesDir(String localModuleKey) {
        return StoragePathManager.getModuleStorageDir(localModuleKey).resolve("issues");
    }

    public static Path getNotificationsDir(String localModuleKey) {
        return StoragePathManager.getModuleStorageDir(localModuleKey).resolve("notifications");
    }
}

