/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.internal;

import java.nio.file.Path;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;
import org.sonarlint.eclipse.core.internal.StoragePathManager;
import org.sonarlint.eclipse.core.internal.event.AnalysisListenerManager;
import org.sonarlint.eclipse.core.internal.extension.SonarLintExtensionTracker;
import org.sonarlint.eclipse.core.internal.jobs.StandaloneSonarLintClientFacade;
import org.sonarlint.eclipse.core.internal.notifications.NotificationsManager;
import org.sonarlint.eclipse.core.internal.notifications.NotificationsTracker;
import org.sonarlint.eclipse.core.internal.notifications.NotificationsTrackerRegistry;
import org.sonarlint.eclipse.core.internal.resources.SonarLintProjectManager;
import org.sonarlint.eclipse.core.internal.server.ServersManager;
import org.sonarlint.eclipse.core.internal.telemetry.SonarLintTelemetry;
import org.sonarlint.eclipse.core.internal.tracking.IssueStore;
import org.sonarlint.eclipse.core.internal.tracking.IssueTracker;
import org.sonarlint.eclipse.core.internal.tracking.IssueTrackerCacheFactory;
import org.sonarlint.eclipse.core.internal.tracking.IssueTrackerRegistry;
import org.sonarlint.eclipse.core.internal.tracking.PersistentIssueTrackerCache;
import org.sonarlint.eclipse.core.internal.tracking.ServerIssueUpdater;
import org.sonarlint.eclipse.core.resource.ISonarLintProject;

public class SonarLintCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.sonarlint.eclipse.core";
    public static final String UI_PLUGIN_ID = "org.sonarlint.eclipse.ui";
    public static final String MARKER_ON_THE_FLY_ID = "org.sonarlint.eclipse.core.sonarlintOnTheFlyProblem";
    public static final String MARKER_REPORT_ID = "org.sonarlint.eclipse.core.sonarlintReportProblem";
    private static SonarLintCorePlugin plugin;
    private static SonarLintProjectManager projectManager;
    private static NotificationsManager notificationsManager;
    private IssueTrackerRegistry issueTrackerRegistry;
    private ServerIssueUpdater serverIssueUpdater;
    private StandaloneSonarLintClientFacade sonarlint;
    private final ServiceTracker<IProxyService, IProxyService> proxyTracker;
    private final SonarLintExtensionTracker extensionTracker = new SonarLintExtensionTracker();
    private AnalysisListenerManager analysisListenerManager = new AnalysisListenerManager();
    private SonarLintTelemetry telemetry = new SonarLintTelemetry();
    private ServersManager serversManager = new ServersManager();
    private NotificationsTrackerRegistry notificationsTrackerRegistry;

    public SonarLintCorePlugin() {
        plugin = this;
        this.proxyTracker = new ServiceTracker(FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext(), IProxyService.class, null);
        this.proxyTracker.open();
    }

    public static SonarLintCorePlugin getInstance() {
        return plugin;
    }

    public synchronized SonarLintProjectManager getProjectManager() {
        if (projectManager == null) {
            projectManager = new SonarLintProjectManager();
        }
        return projectManager;
    }

    public synchronized NotificationsManager notificationsManager() {
        if (notificationsManager == null) {
            notificationsManager = new NotificationsManager();
        }
        return notificationsManager;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.extensionTracker.start();
        this.serversManager.init();
        IssueTrackerCacheFactory factory = (project, localModuleKey) -> {
            Path storeBasePath = StoragePathManager.getIssuesDir(localModuleKey);
            IssueStore issueStore = new IssueStore(storeBasePath, project);
            return new PersistentIssueTrackerCache(issueStore);
        };
        this.issueTrackerRegistry = new IssueTrackerRegistry(factory);
        this.serverIssueUpdater = new ServerIssueUpdater(this.issueTrackerRegistry);
        this.telemetry.init();
        this.notificationsTrackerRegistry = new NotificationsTrackerRegistry();
    }

    public void stop(BundleContext context) throws Exception {
        this.telemetry.stop();
        if (this.sonarlint != null) {
            this.sonarlint.stop();
        }
        this.proxyTracker.close();
        this.issueTrackerRegistry.shutdown();
        this.serversManager.stop();
        this.extensionTracker.close();
        super.stop(context);
    }

    public StandaloneSonarLintClientFacade getDefaultSonarLintClientFacade() {
        if (this.sonarlint == null) {
            this.sonarlint = new StandaloneSonarLintClientFacade();
        }
        return this.sonarlint;
    }

    public IProxyService getProxyService() {
        return (IProxyService)this.proxyTracker.getService();
    }

    public ServerIssueUpdater getServerIssueUpdater() {
        return this.serverIssueUpdater;
    }

    public static IssueTracker getOrCreateIssueTracker(ISonarLintProject project, String localModulePath) {
        return SonarLintCorePlugin.getInstance().issueTrackerRegistry.getOrCreate(project, localModulePath);
    }

    public static void clearIssueTracker(ISonarLintProject project) {
        SonarLintCorePlugin.getInstance().issueTrackerRegistry.get(project).ifPresent(IssueTracker::clear);
    }

    public static AnalysisListenerManager getAnalysisListenerManager() {
        return SonarLintCorePlugin.getInstance().analysisListenerManager;
    }

    public static SonarLintExtensionTracker getExtensionTracker() {
        return SonarLintCorePlugin.getInstance().extensionTracker;
    }

    public static SonarLintTelemetry getTelemetry() {
        return SonarLintCorePlugin.getInstance().telemetry;
    }

    public static ServersManager getServersManager() {
        return SonarLintCorePlugin.getInstance().serversManager;
    }

    public static NotificationsTracker getOrCreateNotificationsTracker(ISonarLintProject project) {
        return SonarLintCorePlugin.getInstance().notificationsTrackerRegistry.getOrCreate(project);
    }
}

