/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.sonarlint.eclipse.core.internal.jobs.LogListener;

public class SonarLintLogger {
    private static final SonarLintLogger instance = new SonarLintLogger();
    private final List<LogListener> logListeners = new ArrayList<LogListener>();

    private SonarLintLogger() {
    }

    public static SonarLintLogger get() {
        return instance;
    }

    public void addLogListener(LogListener listener) {
        this.logListeners.add(listener);
    }

    public void removeLogListener(LogListener listener) {
        this.logListeners.remove(listener);
    }

    public void error(String msg) {
        for (LogListener listener : this.logListeners) {
            listener.error(msg, false);
        }
    }

    public void analyzerError(String msg) {
        for (LogListener listener : this.logListeners) {
            listener.error(msg, true);
        }
    }

    public void error(String msg, Throwable t) {
        for (LogListener listener : this.logListeners) {
            listener.error(msg, false);
            StringWriter stack = new StringWriter();
            t.printStackTrace(new PrintWriter(stack));
            listener.error(stack.toString(), false);
        }
    }

    public void info(String msg) {
        for (LogListener listener : this.logListeners) {
            listener.info(msg, false);
        }
    }

    public void analyzerInfo(String msg) {
        for (LogListener listener : this.logListeners) {
            listener.info(msg, true);
        }
    }

    public void debug(String msg) {
        for (LogListener listener : this.logListeners) {
            listener.debug(msg, false);
        }
    }

    public void analyzerDebug(String msg) {
        for (LogListener listener : this.logListeners) {
            listener.debug(msg, true);
        }
    }

    public void debug(String msg, Throwable t) {
        for (LogListener listener : this.logListeners) {
            listener.debug(msg, false);
            StringWriter stack = new StringWriter();
            t.printStackTrace(new PrintWriter(stack));
            listener.debug(stack.toString(), false);
        }
    }
}

