/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.transformer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.sf.eclipsecs.core.transformer.FormatterConfiguration;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.internal.corext.fix.CleanUpPreferenceUtil;
import org.eclipse.jdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpProfileManager;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpProfileVersioner;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterProfileStore;
import org.eclipse.jdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileVersioner;
import org.osgi.service.prefs.BackingStoreException;

public class FormatterConfigWriter {
    private static final String JDT_UI_PLUGINID = "org.eclipse.jdt.ui";
    private final FormatterConfiguration mConfiguration;
    private final String mNewProfileName;
    private IProject mProject;

    public FormatterConfigWriter(IProject project, FormatterConfiguration settings) {
        this.mConfiguration = settings;
        this.mProject = project;
        this.mNewProfileName = "eclipse-cs " + this.mProject.getName();
        this.writeSettings();
    }

    private void writeSettings() {
        this.writeCleanupSettings(this.mConfiguration.getCleanupSettings());
        this.writeFormatterSettings(this.mConfiguration.getFormatterSettings());
    }

    private void writeCleanupSettings(Map<String, String> settings) {
        PreferencesAccess access = PreferencesAccess.getOriginalPreferences();
        IScopeContext instanceScope = access.getInstanceScope();
        IScopeContext scope = access.getProjectScope(this.mProject);
        CleanUpProfileVersioner versioner = new CleanUpProfileVersioner();
        ProfileStore profilesStore = new ProfileStore("org.eclipse.jdt.ui.cleanupprofiles", (IProfileVersioner)versioner);
        try {
            ArrayList profiles = profilesStore.readProfiles(instanceScope);
            if (profiles == null) {
                profiles = new ArrayList();
            }
            profiles.addAll(CleanUpPreferenceUtil.getBuiltInProfiles());
            CleanUpProfileManager manager = new CleanUpProfileManager(profiles, scope, access, (IProfileVersioner)versioner);
            ProfileManager.CustomProfile myProfile = (ProfileManager.CustomProfile)manager.getProfile("_" + this.mNewProfileName);
            if (myProfile == null) {
                ProfileManager.Profile current = manager.getSelected();
                myProfile = new ProfileManager.CustomProfile(this.mNewProfileName, current.getSettings(), versioner.getCurrentVersion(), versioner.getProfileKind());
                manager.addProfile(myProfile);
            }
            Map joinedSettings = myProfile.getSettings();
            joinedSettings.putAll(settings);
            myProfile.setSettings(joinedSettings);
            manager.setSelected((ProfileManager.Profile)myProfile);
            profilesStore.writeProfiles((Collection)manager.getSortedProfiles(), instanceScope);
            manager.commitChanges(scope);
            scope.getNode(JDT_UI_PLUGINID).flush();
            scope.getNode("org.eclipse.jdt.core").flush();
            if (scope != instanceScope) {
                instanceScope.getNode(JDT_UI_PLUGINID).flush();
                instanceScope.getNode("org.eclipse.jdt.core").flush();
            }
        }
        catch (CoreException e) {
            CheckstyleLog.log(e, "Error storing cleanup profile");
        }
        catch (BackingStoreException e) {
            CheckstyleLog.log(e, "Error storing cleanup profile");
        }
    }

    private void writeFormatterSettings(Map<String, String> settings) {
        PreferencesAccess access = PreferencesAccess.getOriginalPreferences();
        IScopeContext instanceScope = access.getInstanceScope();
        IScopeContext scope = access.getProjectScope(this.mProject);
        ProfileVersioner versioner = new ProfileVersioner();
        FormatterProfileStore profilesStore = new FormatterProfileStore((IProfileVersioner)versioner);
        try {
            FormatterProfileManager manager;
            ProfileManager.CustomProfile myProfile;
            ArrayList profiles = profilesStore.readProfiles(instanceScope);
            if (profiles == null) {
                profiles = new ArrayList();
            }
            if ((myProfile = (ProfileManager.CustomProfile)(manager = new FormatterProfileManager(profiles, scope, access, (IProfileVersioner)versioner)).getProfile("_" + this.mNewProfileName)) == null) {
                ProfileManager.Profile current = manager.getSelected();
                myProfile = new ProfileManager.CustomProfile(this.mNewProfileName, current.getSettings(), versioner.getCurrentVersion(), versioner.getProfileKind());
                manager.addProfile(myProfile);
            }
            Map joinedSettings = myProfile.getSettings();
            joinedSettings.putAll(settings);
            myProfile.setSettings(joinedSettings);
            manager.setSelected((ProfileManager.Profile)myProfile);
            profilesStore.writeProfiles((Collection)manager.getSortedProfiles(), instanceScope);
            manager.commitChanges(scope);
            scope.getNode(JDT_UI_PLUGINID).flush();
            scope.getNode("org.eclipse.jdt.core").flush();
            if (scope != instanceScope) {
                instanceScope.getNode(JDT_UI_PLUGINID).flush();
                instanceScope.getNode("org.eclipse.jdt.core").flush();
            }
        }
        catch (CoreException e) {
            CheckstyleLog.log(e, "Error storing formatter profile");
        }
        catch (BackingStoreException e) {
            CheckstyleLog.log(e, "Error storing formatter profile");
        }
    }
}

