/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.configtypes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.configtypes.ConfigurationType;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.osgi.util.NLS;

public class ProjectConfigurationType
extends ConfigurationType {
    public static final String KEY_PROTECT_CONFIG = "protect-config-file";

    @Override
    protected URL resolveLocation(ICheckConfiguration checkConfiguration) throws IOException {
        IResource configFileResource = ResourcesPlugin.getWorkspace().getRoot().findMember(checkConfiguration.getLocation());
        if (configFileResource != null) {
            return configFileResource.getLocation().toFile().toURI().toURL();
        }
        throw new FileNotFoundException(NLS.bind((String)Messages.ProjectConfigurationType_msgFileNotFound, (Object)checkConfiguration.getLocation()));
    }

    @Override
    public boolean isConfigurable(ICheckConfiguration checkConfiguration) {
        boolean isConfigurable = true;
        boolean isProtected = Boolean.valueOf(checkConfiguration.getAdditionalData().get(KEY_PROTECT_CONFIG));
        boolean bl = isConfigurable = !isProtected;
        if (!isProtected) {
            try {
                File file = URIUtil.toFile((URI)checkConfiguration.getResolvedConfigurationFileURL().toURI());
                isConfigurable = file != null && file.canWrite();
            }
            catch (URISyntaxException | CheckstylePluginException e) {
                CheckstyleLog.log(e);
                isConfigurable = false;
            }
        }
        return isConfigurable;
    }
}

