/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.sf.eclipsecs.core.CheckstylePlugin;
import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.config.CheckConfiguration;
import net.sf.eclipsecs.core.config.GlobalCheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.ICheckConfigurationWorkingSet;
import net.sf.eclipsecs.core.config.ResolvableProperty;
import net.sf.eclipsecs.core.config.configtypes.ConfigurationTypes;
import net.sf.eclipsecs.core.config.configtypes.IConfigurationType;
import net.sf.eclipsecs.core.util.CheckstyleLog;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;

public final class CheckConfigurationFactory {
    protected static final String CHECKSTYLE_CONFIG_FILE = "checkstyle-config.xml";
    private static final String VERSION_5_0_0 = "5.0.0";
    protected static final String CURRENT_CONFIG_FILE_FORMAT_VERSION = "5.0.0";
    private static final String CONFIGS_EXTENSION_POINT = "net.sf.eclipsecs.core.configurations";
    private static List<ICheckConfiguration> sConfigurations = Collections.synchronizedList(new ArrayList());
    private static ICheckConfiguration sDefaultCheckConfig;
    private static ICheckConfiguration sDefaultBuiltInConfig;

    static {
        CheckConfigurationFactory.refresh();
    }

    private CheckConfigurationFactory() {
    }

    public static ICheckConfiguration getByName(String name) {
        for (ICheckConfiguration config : sConfigurations) {
            if (!config.getName().equals(name)) continue;
            return config;
        }
        return null;
    }

    public static List<ICheckConfiguration> getCheckConfigurations() {
        return Collections.unmodifiableList(sConfigurations);
    }

    public static ICheckConfiguration getDefaultCheckConfiguration() {
        if (sDefaultCheckConfig != null) {
            return sDefaultCheckConfig;
        }
        if (sDefaultBuiltInConfig != null) {
            return sDefaultBuiltInConfig;
        }
        if (sConfigurations.size() > 0) {
            return sConfigurations.get(0);
        }
        return null;
    }

    public static ICheckConfigurationWorkingSet newWorkingSet() {
        return new GlobalCheckConfigurationWorkingSet(sConfigurations, CheckConfigurationFactory.getDefaultCheckConfiguration(), sDefaultBuiltInConfig);
    }

    public static void refresh() {
        try {
            sDefaultCheckConfig = null;
            sDefaultBuiltInConfig = null;
            sConfigurations.clear();
            CheckConfigurationFactory.loadBuiltinConfigurations();
            CheckConfigurationFactory.loadFromPersistence();
        }
        catch (CheckstylePluginException e) {
            CheckstyleLog.log(e);
        }
    }

    public static void copyConfiguration(ICheckConfiguration source, ICheckConfiguration target) throws CheckstylePluginException {
        try {
            File targetFile = URIUtil.toFile((URI)target.getResolvedConfigurationFileURL().toURI());
            File sourceFile = URIUtil.toFile((URI)source.getResolvedConfigurationFileURL().toURI());
            if (Objects.equals(targetFile, sourceFile)) {
                return;
            }
            CheckConfigurationFactory.exportConfiguration(targetFile, source);
        }
        catch (URISyntaxException e) {
            CheckstylePluginException.rethrow(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void exportConfiguration(File file, ICheckConfiguration config) throws CheckstylePluginException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                ByteArrayInputStream in = config.getCheckstyleConfiguration().getCheckConfigFileStream();
                try {
                    try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                        ByteStreams.copy((InputStream)in, (OutputStream)out);
                    }
                    if (in == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    ((InputStream)in).close();
                    throw throwable;
                }
                ((InputStream)in).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            CheckstylePluginException.rethrow(e);
        }
    }

    public static void transferInternalConfiguration(IPath targetWorkspaceRoot) throws CheckstylePluginException {
        IPath targetStateLocation = CheckConfigurationFactory.getTargetStateLocation(targetWorkspaceRoot);
        File targetLocationFile = targetStateLocation.toFile();
        try {
            targetLocationFile.mkdirs();
            final Path sourcePath = CheckstylePlugin.getDefault().getStateLocation().toFile().toPath();
            final Path targetPath = targetLocationFile.toPath();
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Files.createDirectories(targetPath.resolve(sourcePath.relativize(dir)), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, targetPath.resolve(sourcePath.relativize(file)), new CopyOption[0]);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IllegalStateException e) {
            CheckstylePluginException.rethrow(e);
        }
        catch (IOException e) {
            CheckstylePluginException.rethrow(e);
        }
    }

    private static IPath getTargetStateLocation(IPath newWorkspaceRoot) {
        IPath currentWorkspaceRoot = Platform.getLocation();
        IPath currentStateLocation = CheckstylePlugin.getDefault().getStateLocation();
        if (currentStateLocation == null) {
            return null;
        }
        int segmentsToRemove = currentStateLocation.matchingFirstSegments(currentWorkspaceRoot);
        currentStateLocation = currentStateLocation.removeFirstSegments(segmentsToRemove);
        IPath targetStateLocation = newWorkspaceRoot.append(currentStateLocation);
        return targetStateLocation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadFromPersistence() throws CheckstylePluginException {
        File configFile = CheckConfigurationFactory.getInternalConfigurationFile();
        if (!configFile.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(configFile));
                try {
                    SAXReader reader = new SAXReader();
                    Document document = reader.read((InputStream)inStream);
                    Element root = document.getRootElement();
                    String version = root.attributeValue("file-format-version");
                    if (!"5.0.0".equals(version)) {
                        CheckstyleLog.log(null, "eclipse-cs version 3.x type configuration files are not supported anymore.");
                        return;
                    }
                    String defaultConfigName = root.attributeValue("default-check-configuration");
                    sConfigurations.addAll(CheckConfigurationFactory.getGlobalCheckConfigurations(root));
                    Iterator<ICheckConfiguration> iterator = sConfigurations.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return;
                        }
                        ICheckConfiguration config = iterator.next();
                        if (!config.getName().equals(defaultConfigName) || config == sDefaultBuiltInConfig) continue;
                        sDefaultCheckConfig = config;
                    }
                }
                finally {
                    if (inStream == null) return;
                    ((InputStream)inStream).close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException | DocumentException e) {
            CheckstylePluginException.rethrow(e, Messages.errorLoadingConfigFile);
        }
    }

    private static File getInternalConfigurationFile() {
        IPath configPath = CheckstylePlugin.getDefault().getStateLocation();
        configPath = configPath.append(CHECKSTYLE_CONFIG_FILE);
        File configFile = configPath.toFile();
        return configFile;
    }

    private static void loadBuiltinConfigurations() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = pluginRegistry.getConfigurationElementsFor(CONFIGS_EXTENSION_POINT);
        int currentMaxDefaultWeight = -1;
        CheckConfiguration defaultBuiltInCheckConfig = null;
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement[] propEls;
            String name = elements[i].getAttribute("name");
            String description = elements[i].getAttribute("description");
            String location = elements[i].getAttribute("location");
            String defaultWeightAsString = elements[i].getAttribute("default-weight");
            int defaultWeight = defaultWeightAsString != null ? Integer.parseInt(defaultWeightAsString) : 0;
            IConfigurationType configType = ConfigurationTypes.getByInternalName("builtin");
            HashMap<String, String> additionalData = new HashMap<String, String>();
            additionalData.put("contributor", elements[i].getContributor().getName());
            ArrayList<ResolvableProperty> props = new ArrayList<ResolvableProperty>();
            IConfigurationElement[] iConfigurationElementArray = propEls = elements[i].getChildren("property");
            int n = propEls.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement propEl = iConfigurationElementArray[n2];
                props.add(new ResolvableProperty(propEl.getAttribute("name"), propEl.getAttribute("value")));
                ++n2;
            }
            CheckConfiguration checkConfig = new CheckConfiguration(name, location, description, configType, true, props, additionalData);
            sConfigurations.add(checkConfig);
            if (defaultWeight > currentMaxDefaultWeight) {
                currentMaxDefaultWeight = defaultWeight;
                defaultBuiltInCheckConfig = checkConfig;
            }
            ++i;
        }
        sDefaultBuiltInConfig = defaultBuiltInCheckConfig;
    }

    private static List<ICheckConfiguration> getGlobalCheckConfigurations(Element root) {
        ArrayList<ICheckConfiguration> configs = new ArrayList<ICheckConfiguration>();
        List configElements = root.elements("check-configuration");
        for (Element configEl : configElements) {
            String name = configEl.attributeValue("name");
            String description = configEl.attributeValue("description");
            String location = configEl.attributeValue("location");
            String type = configEl.attributeValue("type");
            IConfigurationType configType = ConfigurationTypes.getByInternalName(type);
            ArrayList<ResolvableProperty> props = new ArrayList<ResolvableProperty>();
            List propertiesElements = configEl.elements("property");
            for (Element propsEl : propertiesElements) {
                ResolvableProperty prop = new ResolvableProperty(propsEl.attributeValue("name"), propsEl.attributeValue("value"));
                props.add(prop);
            }
            HashMap<String, String> additionalData = new HashMap<String, String>();
            List dataElements = configEl.elements("additional-data");
            for (Element dataEl : dataElements) {
                additionalData.put(dataEl.attributeValue("name"), dataEl.attributeValue("value"));
            }
            CheckConfiguration checkConfig = new CheckConfiguration(name, location, description, configType, true, props, additionalData);
            configs.add(checkConfig);
        }
        return configs;
    }
}

