/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.eclipsecs.core.config.CheckstyleConfigurationFile;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.ResolvableProperty;
import net.sf.eclipsecs.core.config.configtypes.IConfigurationType;
import net.sf.eclipsecs.core.util.CheckstylePluginException;

public class CheckConfiguration
implements ICheckConfiguration {
    private final String mName;
    private final String mLocation;
    private final String mDescription;
    private final IConfigurationType mConfigType;
    private final boolean mIsGlobal;
    private final List<ResolvableProperty> mProperties;
    private Map<String, String> mAdditionalData;
    private CheckstyleConfigurationFile mCheckstyleConfigurationFile;
    private long mExpirationTime = 0L;

    public CheckConfiguration(String name, String location, String description, IConfigurationType type, boolean global, List<ResolvableProperty> properties, Map<String, String> additionalData) {
        this.mName = name;
        this.mLocation = location;
        this.mDescription = description;
        this.mConfigType = type;
        this.mIsGlobal = global;
        this.mAdditionalData = additionalData != null ? Collections.unmodifiableMap(additionalData) : Collections.unmodifiableMap(new HashMap());
        this.mProperties = properties != null ? Collections.unmodifiableList(properties) : Collections.unmodifiableList(new ArrayList());
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getLocation() {
        return this.mLocation;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public IConfigurationType getType() {
        return this.mConfigType;
    }

    @Override
    public Map<String, String> getAdditionalData() {
        return this.mAdditionalData;
    }

    @Override
    public List<ResolvableProperty> getResolvableProperties() {
        return this.mProperties;
    }

    @Override
    public boolean isEditable() {
        return this.mConfigType.isEditable();
    }

    @Override
    public boolean isConfigurable() {
        return this.mConfigType.isConfigurable(this);
    }

    @Override
    public boolean isGlobal() {
        return this.mIsGlobal;
    }

    @Override
    public URL getResolvedConfigurationFileURL() throws CheckstylePluginException {
        return this.getType().getResolvedConfigurationFileURL(this);
    }

    @Override
    public CheckstyleConfigurationFile getCheckstyleConfiguration() throws CheckstylePluginException {
        long currentTime = System.currentTimeMillis();
        if (this.mCheckstyleConfigurationFile == null || currentTime > this.mExpirationTime) {
            this.mCheckstyleConfigurationFile = this.getType().getCheckstyleConfiguration(this);
            this.mExpirationTime = currentTime + 3600000L;
        }
        return this.mCheckstyleConfigurationFile;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ICheckConfiguration)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ICheckConfiguration rhs = (ICheckConfiguration)obj;
        return Objects.equals(this.getName(), rhs.getName()) && Objects.equals(this.getLocation(), rhs.getLocation()) && Objects.equals(this.getDescription(), rhs.getDescription()) && Objects.equals(this.getType(), rhs.getType()) && this.isGlobal() == rhs.isGlobal() && Objects.equals(this.getResolvableProperties(), rhs.getResolvableProperties()) && Objects.equals(this.getAdditionalData(), rhs.getAdditionalData());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getLocation(), this.getDescription(), this.getType(), this.isGlobal(), this.getResolvableProperties(), this.getAdditionalData());
    }
}

