/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.builder;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.io.Closeables;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.eclipsecs.core.CheckstylePlugin;
import net.sf.eclipsecs.core.builder.ProjectClassLoader;
import net.sf.eclipsecs.core.config.CheckstyleConfigurationFile;
import net.sf.eclipsecs.core.config.ConfigurationReader;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.configtypes.IContextAware;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.xml.sax.InputSource;

public final class CheckerFactory {
    private static Cache<String, Checker> sCheckerMap = CacheBuilder.newBuilder().softValues().build();
    private static Map<String, Long> sModifiedMap = new ConcurrentHashMap<String, Long>();
    private static Map<String, ConfigurationReader.AdditionalConfigData> sAdditionalDataMap = new ConcurrentHashMap<String, ConfigurationReader.AdditionalConfigData>();
    private static ProjectClassLoader sSharedClassLoader = new ProjectClassLoader();

    private CheckerFactory() {
    }

    public static Checker createChecker(ICheckConfiguration config, IProject project) throws CheckstyleException, CheckstylePluginException {
        CheckstyleConfigurationFile configFileData;
        String cacheKey = CheckerFactory.getCacheKey(config, project);
        Checker checker = CheckerFactory.tryCheckerCache(cacheKey, (configFileData = config.getCheckstyleConfiguration()).getModificationStamp());
        if (checker != null) {
            checker.clearCache();
        }
        if (checker == null) {
            PropertyResolver resolver = configFileData.getPropertyResolver();
            if (resolver instanceof IContextAware) {
                ((IContextAware)resolver).setProjectContext(project);
            }
            InputSource in = null;
            try {
                in = configFileData.getCheckConfigFileInputSource();
                checker = CheckerFactory.createCheckerInternal(in, resolver, project);
            }
            finally {
                Closeables.closeQuietly((InputStream)in.getByteStream());
            }
            Long modified = new Long(configFileData.getModificationStamp());
            sCheckerMap.put((Object)cacheKey, (Object)checker);
            sModifiedMap.put(cacheKey, modified);
        }
        return checker;
    }

    public static ConfigurationReader.AdditionalConfigData getAdditionalData(ICheckConfiguration config, IProject project) throws CheckstylePluginException {
        String cacheKey = CheckerFactory.getCacheKey(config, project);
        ConfigurationReader.AdditionalConfigData additionalData = sAdditionalDataMap.get(cacheKey);
        if (additionalData == null) {
            CheckstyleConfigurationFile configFileData = config.getCheckstyleConfiguration();
            InputSource in = null;
            try {
                in = configFileData.getCheckConfigFileInputSource();
                additionalData = ConfigurationReader.getAdditionalConfigData(in);
            }
            finally {
                Closeables.closeQuietly((InputStream)in.getByteStream());
            }
            sAdditionalDataMap.put(cacheKey, additionalData);
        }
        return additionalData;
    }

    public static ProjectClassLoader getSharedClassLoader() {
        return sSharedClassLoader;
    }

    public static void cleanup() {
        sCheckerMap.invalidateAll();
        sModifiedMap.clear();
        sAdditionalDataMap.clear();
    }

    private static String getCacheKey(ICheckConfiguration config, IProject project) throws CheckstylePluginException {
        CheckstyleConfigurationFile configFileData = config.getCheckstyleConfiguration();
        URL configLocation = configFileData.getResolvedConfigFileURL();
        String checkConfigName = String.valueOf(config.getName()) + "#" + (config.isGlobal() ? "Global" : "Local");
        String cacheKey = String.valueOf(project.getName()) + "#" + configLocation + "#" + checkConfigName;
        return cacheKey;
    }

    private static Checker tryCheckerCache(String cacheKey, long modificationStamp) {
        Checker checker = (Checker)sCheckerMap.getIfPresent((Object)cacheKey);
        if (checker != null) {
            Long oldTime = sModifiedMap.get(cacheKey);
            Long newTime = new Long(modificationStamp);
            if (oldTime == null || oldTime.compareTo(newTime) != 0) {
                checker = null;
                sCheckerMap.invalidate((Object)cacheKey);
                sModifiedMap.remove(cacheKey);
                sAdditionalDataMap.remove(cacheKey);
            }
        }
        return checker;
    }

    private static Checker createCheckerInternal(InputSource input, PropertyResolver propResolver, IProject project) throws CheckstyleException, CheckstylePluginException {
        Configuration configuration = ConfigurationLoader.loadConfiguration((InputSource)input, (PropertyResolver)propResolver, (boolean)true);
        Checker checker = new Checker();
        checker.setModuleClassLoader(CheckstylePlugin.getDefault().getAddonExtensionClassLoader());
        try {
            checker.setCharset(project.getDefaultCharset());
        }
        catch (UnsupportedEncodingException e) {
            CheckstylePluginException.rethrow(e);
        }
        catch (CoreException e) {
            CheckstylePluginException.rethrow(e);
        }
        Locale platformLocale = CheckstylePlugin.getPlatformLocale();
        checker.setLocaleLanguage(platformLocale.getLanguage());
        checker.setLocaleCountry(platformLocale.getCountry());
        checker.setClassLoader((ClassLoader)sSharedClassLoader);
        checker.configure(configuration);
        checker.setBasedir(null);
        return checker;
    }
}

