/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.core.util;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.springsource.ide.eclipse.commons.internal.core.CorePlugin;

public class ProcessUtils {
    public static long getProcessID(Process p) {
        long result = -1L;
        try {
            Field f = p.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            result = f.getLong(p);
            f.setAccessible(false);
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("Process PID calculation not supported on the current platform", ex);
        }
        return result;
    }

    public static JMXConnector createJMXConnector(String pid) {
        List<VirtualMachineDescriptor> vmds = VirtualMachine.list();
        VirtualMachineDescriptor vmd = vmds.stream().filter(descriptor -> descriptor.id().equals(pid)).findFirst().orElse(null);
        if (vmd != null) {
            try {
                String agentUrl = VirtualMachine.attach(vmd).startLocalManagementAgent();
                if (agentUrl != null) {
                    JMXServiceURL serviceUrl = new JMXServiceURL(agentUrl);
                    return JMXConnectorFactory.connect(serviceUrl, null);
                }
            }
            catch (AttachNotSupportedException e) {
                CorePlugin.log(e);
            }
            catch (IOException e) {
                CorePlugin.log(e);
            }
        }
        return null;
    }

    public static boolean isLatestJdkForTools() {
        try {
            return VirtualMachine.class.getDeclaredMethod("startLocalManagementAgent", new Class[0]) != null;
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return false;
        }
    }
}

