/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.core.util;

import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;

public class OsUtils {
    private static final PosixFilePermission[] decodeMap = new PosixFilePermission[]{PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_READ};

    public static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    public static Set<PosixFilePermission> posixFilePermissions(int mode) {
        int mask = 1;
        EnumSet<PosixFilePermission> perms = EnumSet.noneOf(PosixFilePermission.class);
        PosixFilePermission[] posixFilePermissionArray = decodeMap;
        int n = decodeMap.length;
        int n2 = 0;
        while (n2 < n) {
            PosixFilePermission flag = posixFilePermissionArray[n2];
            if (flag != null && (mask & mode) != 0) {
                perms.add(flag);
            }
            mask <<= 1;
            ++n2;
        }
        return perms;
    }
}

