/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.text.IRegion;

public class FuzzyMatcher {
    public static Collection<IRegion> highlights(CharSequence query, String data) {
        ArrayList<IRegion> highlights = new ArrayList<IRegion>();
        int qpos = 0;
        int dpos = 0;
        int qlen = query.length();
        int dlen = data.length();
        while (qpos < qlen && dpos < dlen) {
            int nextMatch = data.indexOf(query.charAt(qpos), dpos);
            if (nextMatch < 0) {
                return highlights;
            }
            FuzzyMatcher.addMatch(highlights, nextMatch);
            ++qpos;
            dpos = nextMatch + 1;
        }
        return highlights;
    }

    private static void addMatch(List<IRegion> highlights, int nextMatch) {
        Region lastRegion;
        if (highlights.isEmpty()) {
            highlights.add(new Region(nextMatch, nextMatch + 1));
        }
        if ((lastRegion = (Region)highlights.get(highlights.size() - 1)).getOffset() + lastRegion.getLength() == nextMatch) {
            ++lastRegion.end;
        } else {
            highlights.add(new Region(nextMatch, nextMatch + 1));
        }
    }

    /*
     * Unable to fully structure code
     */
    public static double matchScore(CharSequence pattern, String data) {
        ppos = 0;
        dpos = 0;
        gaps = 0;
        skips = 0;
        plen = pattern.length();
        if (plen <= (dlen = data.length())) ** GOTO lbl17
        return 0.0;
lbl-1000:
        // 1 sources

        {
            if (dpos >= dlen) {
                return 0.0;
            }
            if ((foundCharAt = data.indexOf(c = pattern.charAt(ppos++), dpos)) >= 0) {
                if (foundCharAt > dpos) {
                    ++gaps;
                    skips += foundCharAt - dpos;
                }
                dpos = foundCharAt + 1;
                continue;
            }
            return 0.0;
lbl17:
            // 2 sources

            ** while (ppos < plen)
        }
lbl18:
        // 1 sources

        if (dpos < dlen) {
            skips += dlen - dpos;
        }
        return FuzzyMatcher.score(gaps, skips, pattern);
    }

    private static double score(int gaps, int skips, CharSequence pattern) {
        if (gaps == 0) {
            return 0.5 + (double)pattern.length();
        }
        double badness = (double)(1 + gaps) + (double)skips / 1000.0;
        return 1.0 / badness + (double)pattern.length();
    }

    private static class Region
    implements IRegion {
        int start;
        int end;

        public Region(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getLength() {
            return this.end - this.start;
        }

        public int getOffset() {
            return this.start;
        }

        public String toString() {
            return "Region[" + this.start + ".." + this.end + "]";
        }
    }
}

