/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.core.preferences;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.springsource.ide.eclipse.commons.internal.core.CorePlugin;

public class StsProperties {
    private static StsProperties instance = null;
    private final Properties props;

    public static StsProperties getInstance(IProgressMonitor mon) {
        if (instance == null) {
            StsProperties newInstance;
            instance = newInstance = new StsProperties(mon);
        }
        return instance;
    }

    private StsProperties(IProgressMonitor mon) {
        mon.beginTask("Read Sts Properties", 11);
        try {
            this.props = this.createProperties();
        }
        finally {
            mon.done();
        }
    }

    protected Properties createProperties() {
        Properties props = new Properties();
        props.put("spring.site.url", "http://spring.io");
        props.put("spring.initializr.json.url", "http://start.spring.io");
        props.put("spring.docs.url", "https://spring.io/docs");
        props.put("spring.docs.url.label", "Spring Docs");
        props.put("spring.docs.url.external", "false");
        props.put("spring.blog.url", "https://spring.io/blog");
        props.put("spring.blog.url.label", "Blog");
        props.put("spring.blog.url.external", "false");
        props.put("sts.tracker.url", "https://github.com/spring-projects/spring-ide/issues");
        props.put("sts.tracker.url.label", "Issues");
        props.put("sts.tracker.url.external", "true");
        props.put("sts.nan.url", "http://static.springsource.org/sts/nan/latest/NewAndNoteworthy.html");
        props.put("sts.nan.url.label", "New and Noteworthy");
        props.put("sts.nan.url.external", "false");
        props.put("sts.forum.url", "http://forum.springsource.org/forumdisplay.php?32-SpringSource-Tool-Suite");
        props.put("sts.forum.url.label", "Forum");
        props.put("sts.forum.url.external", "false");
        props.put("spring.guides.url", "https://spring.io/guides");
        props.put("spring.guides.url.label", "Guides");
        props.put("spring.guides.url.external", "true");
        props.put("spring.boot.install.url", "http://repo.spring.io/release/org/springframework/boot/spring-boot-cli/1.5.9.RELEASE/spring-boot-cli-1.5.9.RELEASE-bin.zip");
        props.put("spring.reference.app.discovery.url", "https://raw.github.com/kdvolder/spring-reference-apps-meta/master/reference-apps.json");
        props.put("spring.boot.typegraph.url", "http://aetherial.cfapps.io/boot/typegraph");
        props.put("spring.boot.default.version", "1.5.9.RELEASE");
        props.put("spring.boot.cloud.default.version", "1.4.0.RELEASE");
        return props;
    }

    public Collection<String> getExplicitProperties() {
        ArrayList<String> keys = new ArrayList<String>();
        for (Object string : this.props.keySet()) {
            if (!(string instanceof String)) continue;
            keys.add((String)string);
        }
        return keys;
    }

    public String get(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            value = this.props.getProperty(key);
        }
        return value;
    }

    public boolean get(String key, boolean deflt) {
        String value = this.get(key);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return deflt;
    }

    public static StsProperties getInstance() {
        return StsProperties.getInstance((IProgressMonitor)new NullProgressMonitor());
    }

    public URL url(String prop) {
        String s = this.get(prop);
        try {
            if (s != null) {
                return new URL(this.get(prop));
            }
        }
        catch (Exception e) {
            CorePlugin.log(e);
        }
        return null;
    }
}

