/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.springsource.ide.eclipse.commons.core.Policy;

public class FileUtil {
    private static final int MAX_FILE_SIZE = 0x100000;
    public static final int BUFFER_SIZE = 4096;
    private static String[] BINARY_EXTENSIONS = new String[]{"jar", "gif", "jpg", "jpeg", ".class", "png"};

    public static void copyDirectory(File sourceDirectory, File targetDirectory, IProgressMonitor monitor) throws CoreException {
        File[] files = sourceDirectory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File sourceFile = fileArray[n2];
                File targetFile = new File(targetDirectory, sourceFile.getName());
                if (sourceFile.isDirectory()) {
                    targetFile.mkdir();
                    FileUtil.copyDirectory(sourceFile, targetFile, monitor);
                } else {
                    FileUtil.copyFile(sourceFile, targetFile, monitor);
                }
                ++n2;
            }
        }
    }

    public static void copyFile(File sourceFile, File targetFile, IProgressMonitor monitor) throws CoreException {
        try {
            try {
                monitor.beginTask("Copying file", (int)sourceFile.length());
                try (FileInputStream in = new FileInputStream(sourceFile);){
                    FileUtil.writeToFile(in, targetFile, monitor);
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.core", "Could not copy file from " + sourceFile + " to " + targetFile, (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    public static void writeToFile(InputStream in, File targetFile, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        try (FileOutputStream out = new FileOutputStream(targetFile);){
            int len;
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer)) > 0) {
                Policy.checkCancelled(monitor);
                out.write(buffer, 0, len);
                monitor.worked(len);
            }
        }
    }

    public static File getFile(Bundle bundle, String filename) throws CoreException {
        URL url = bundle.getResource(filename);
        if (url == null) {
            throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.core", "Could not locate file: " + filename, (Throwable)new FileNotFoundException()));
        }
        try {
            return new File(FileLocator.toFileURL((URL)url).getPath());
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.core", "Could not locate file: " + filename, (Throwable)e));
        }
    }

    public static File getFile(Plugin plugin, String filename) throws CoreException {
        return FileUtil.getFile(plugin.getBundle(), filename);
    }

    public static String readFile(File sourceFile, IProgressMonitor monitor) throws CoreException {
        long length = sourceFile.length();
        if (length > 0x100000L) {
            throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.core", "File \"" + sourceFile + "\" is too large"));
        }
        try {
            String string;
            monitor.beginTask("Reading file", (int)length);
            FileReader in = new FileReader(sourceFile);
            try {
                int len;
                StringBuilder sb = new StringBuilder((int)length);
                char[] buffer = new char[4096];
                while ((len = in.read(buffer)) > 0) {
                    Policy.checkCancelled(monitor);
                    sb.append(buffer, 0, len);
                    monitor.worked(len);
                }
                string = sb.toString();
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.core", "Could not read file \"" + sourceFile + "\"", (Throwable)e));
                }
            }
            in.close();
            return string;
        }
        finally {
            monitor.done();
        }
    }

    public static void copy(File source, File target) throws IOException {
        FileInputStream sourceOutStream = new FileInputStream(source);
        FileOutputStream targetOutStream = new FileOutputStream(target);
        FileChannel sourceChannel = sourceOutStream.getChannel();
        FileChannel targetChannel = targetOutStream.getChannel();
        sourceChannel.transferTo(0L, sourceChannel.size(), targetChannel);
        sourceChannel.close();
        targetChannel.close();
        sourceOutStream.close();
        targetOutStream.close();
    }

    public static boolean isBinaryFile(File file) {
        String extension = FileUtil.getExtension(file);
        if (extension != null) {
            String[] stringArray = BINARY_EXTENSIONS;
            int n = BINARY_EXTENSIONS.length;
            int n2 = 0;
            while (n2 < n) {
                String binaryExtension = stringArray[n2];
                if (binaryExtension.equals(extension)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static String getExtension(File file) {
        String fileName = file.getName();
        int extensionIndex = fileName.lastIndexOf(46);
        if (extensionIndex == -1) {
            return null;
        }
        return fileName.substring(extensionIndex + 1);
    }
}

